/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ig extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_DE = "Jaman\u1ecb";
        final String metaValue_NR = "Nauru";
        final String metaValue_RO = "Romania";
        final String metaValue_TV = "Tuvalu";
        final String metaValue_ccp = "Chakma";
        final String metaValue_lo = "La\u1ecd";
        final String metaValue_or = "\u1eccd\u1ecba";
        final String metaValue_si = "Sinhala";
        final String metaValue_te = "Tel\u1ee5g\u1ee5";
        final String metaValue_type_ca_islamic = "Kalenda Hijri";
        final Object[][] data = new Object[][] {
            { "001", "Uwa" },
            { "002", "Afrika" },
            { "003", "Mpaghara Ugwu Amer\u1ecbka" },
            { "005", "Mpaghara Mgbada Ugwu America" },
            { "009", "Oceania" },
            { "011", "Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Afr\u1ecbka" },
            { "013", "Etiti America" },
            { "014", "Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Afr\u1ecbka" },
            { "015", "Mpaghara Ugwu Afr\u1ecbka" },
            { "017", "Etiti Afr\u1ecbka" },
            { "018", "Mpaghara Mgbada Ugwu Afr\u1ecbka" },
            { "019", "Amer\u1ecbka" },
            { "021", "Mpaghara Ugwu America" },
            { "029", "Onye Carrabean" },
            { "030", "Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Asia" },
            { "034", "Mpaghara Mgbada Ugwu Asia" },
            { "035", "Mpaghara Mgbada Ugwu Asia d\u1ecb na \u1eccw\u1ee5wa Anyanw\u1ee5" },
            { "039", "Mpaghara Mgbada Ugwu Europe" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "057", "Mpaghara Micronesian" },
            { "061", "Polynesia" },
            { "142", "Asia" },
            { "143", "Etiti Asia" },
            { "145", "Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Asia" },
            { "150", "Europe" },
            { "151", "Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Europe" },
            { "154", "Mpaghara Ugwu Europe" },
            { "155", "Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Europe" },
            { "202", "Sub-Saharan Afr\u1ecbka" },
            { "419", "Latin America" },
            { "AC", "Ascension Island" },
            { "AD", "Andorra" },
            { "AE", "United Arab Emirates" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua na Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antarctica" },
            { "AR", "Argentina" },
            { "AS", "American Samoa" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Agwaetiti Aland" },
            { "AZ", "Azerbaijan" },
            { "BA", "Bosnia & Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgium" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Binin" },
            { "BL", "Barth\u00e9lemy D\u1ecb ns\u1ecd" },
            { "BM", "Bemuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Caribbean Netherlands" },
            { "BR", "Brazil" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Agwaetiti Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Agwaetiti Cocos (Keeling)" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Central African Republik" },
            { "CG", "Congo" },
            { "CH", "Switzerland" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Agwaetiti Cook" },
            { "CL", "Chile" },
            { "CM", "Cameroon" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "CP", "Agwaetiti Clipperton" },
            { "CR", "Kosta Rika" },
            { "CU", "Cuba" },
            { "CV", "Cape Verde" },
            { "CW", "Kurakao" },
            { "CX", "Agwaetiti Christmas" },
            { "CY", "Cyprus" },
            { "CZ", "Czechia" },
            { "DE", metaValue_DE },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Denmark" },
            { "DM", "Dominika" },
            { "DO", "Dominican Republik" },
            { "DZ", "Algeria" },
            { "EA", "Ceuta & Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estonia" },
            { "EG", "Egypt" },
            { "EH", "\u1eccd\u1ecbda Anyanw\u1ee5 Sahara" },
            { "ER", "Eritrea" },
            { "ES", "Spain" },
            { "ET", "Ethiopia" },
            { "EU", "Otu nzuk\u1ecd mba Europe" },
            { "EZ", "Gburugburu Euro" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Agwaetiti Falkland" },
            { "FM", "Micronesia" },
            { "FO", "Agwaetiti Faroe" },
            { "FR", "France" },
            { "GA", "Gabon" },
            { "GB", "United Kingdom" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Frenchi Guiana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Greenland" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Equatorial Guinea" },
            { "GR", "Greece" },
            { "GS", "South Georgia na Agwaetiti South Sandwich" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hong Kong SAR China" },
            { "HM", "Agwaetiti Heard na Agwaetiti McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croatia" },
            { "HT", "Hati" },
            { "HU", "Hungary" },
            { "IC", "Agwaetiti Kanar\u1ecb" },
            { "ID", "Indonesia" },
            { "IE", "Ireland" },
            { "IL", "Israel" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "IO", "British Indian Ocean Territory" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", "Iceland" },
            { "IT", "Italy" },
            { "JE", "Jersey" },
            { "JM", "Jamaika" },
            { "JO", "Jordan" },
            { "JP", "Japan" },
            { "KE", "Kenya" },
            { "KG", "Kyrgyzstan" },
            { "KH", "Cambodia" },
            { "KI", "Kiribati" },
            { "KM", "Comorosu" },
            { "KN", "Kitts na Nevis D\u1ecb ns\u1ecd" },
            { "KP", "Ugwu Korea" },
            { "KR", "South Korea" },
            { "KW", "Kuwait" },
            { "KY", "Agwaetiti Cayman" },
            { "KZ", "Kazakhstan" },
            { "LA", "Laos" },
            { "LB", "Lebanon" },
            { "LC", "Lucia D\u1ecb ns\u1ecd" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lithuania" },
            { "LU", "Luxembourg" },
            { "LV", "Latvia" },
            { "LY", "Libia" },
            { "MA", "Morocco" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "Martin D\u1ecb ns\u1ecd" },
            { "MG", "Madagaskar" },
            { "MH", "Agwaetiti Marshall" },
            { "MK", "North Macedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolia" },
            { "MO", "Macao SAR China" },
            { "MP", "Agwaetiti Northern Mariana" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maldivesa" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambik" },
            { "NA", "Namibia" },
            { "NC", "New Caledonia" },
            { "NE", "Niger" },
            { "NF", "Agwaetiti Norfolk" },
            { "NG", "Na\u1ecbj\u1ecbr\u1ecba" },
            { "NI", "Nicaragua" },
            { "NL", "Netherlands" },
            { "NO", "Norway" },
            { "NP", "Nepal" },
            { "NR", metaValue_NR },
            { "NU", "Niue" },
            { "NZ", "New Zealand" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Frenchi Polynesia" },
            { "PG", "Papua New Guinea" },
            { "PH", "Philippines" },
            { "PK", "Pakistan" },
            { "PL", "Poland" },
            { "PM", "Pierre na Miquelon D\u1ecb ns\u1ecd" },
            { "PN", "Agwaetiti Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestinian Territories" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Outlying Oceania" },
            { "RE", "R\u00e9union" },
            { "RO", metaValue_RO },
            { "RS", "Serbia" },
            { "RU", "R\u1ee5ss\u1ecba" },
            { "RW", "Rwanda" },
            { "SA", "Saudi Arabia" },
            { "SB", "Agwaetiti Solomon" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "SE", "Sweden" },
            { "SG", "Singapore" },
            { "SH", "St. Helena" },
            { "SI", "Slovenia" },
            { "SJ", "Svalbard & Jan Mayen" },
            { "SK", "Slovakia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Suriname" },
            { "SS", "South Sudan" },
            { "ST", "S\u00e3o Tom\u00e9 & Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Agwaetiti Turks na Caicos" },
            { "TD", "Chad" },
            { "TF", "\u1ee4m\u1ee5 ngalaba Frenchi Southern" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tajikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Turkey" },
            { "TT", "Trinidad na Tobago" },
            { "TV", metaValue_TV },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", "Ukraine" },
            { "UG", "Uganda" },
            { "UM", "Obere Agwaetiti D\u1ecb Na Mp\u1ee5ga U.S" },
            { "UN", "Mba \u1ee4wa Jik\u1ecdr\u1ecd \u1eccn\u1ee5" },
            { "US", "United States" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistan" },
            { "VA", "Vatican City" },
            { "VC", "Vincent na Grenadines D\u1ecb ns\u1ecd" },
            { "VE", "Venezuela" },
            { "VG", "Agwaetiti British Virgin" },
            { "VI", "Agwaetiti Virgin nke US" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis & Futuna" },
            { "WS", "Samoa" },
            { "XA", "Pseudo-Accents" },
            { "XB", "Pseudo-Bidi" },
            { "XK", "Kosovo" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "South Africa" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Mpaghara Amagh\u1ecb" },
            { "ab", "Abkaziani" },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "am", "Amariik\u1ecb" },
            { "an", "Aragonis\u1ecb" },
            { "ar", "Arabiik\u1ecb" },
            { "as", "Asamis\u1ecb" },
            { "av", "Avar\u1ecbk" },
            { "ay", "Ay\u1ecbmar\u00e0" },
            { "az", "Azerbajan\u1ecb" },
            { "ba", "Bashki" },
            { "be", "Belarusian\u1ee5" },
            { "bg", "B\u1ecdl\u1ee5gar\u1ecba" },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", "Bengali" },
            { "bo", "Tibetan" },
            { "br", "Breton" },
            { "bs", "Bosnia" },
            { "ca", "Catalan" },
            { "ce", "Chechen" },
            { "ch", "Chamoro" },
            { "co", "K\u1ecds\u1ecban" },
            { "cs", "Cheek\u1ecb" },
            { "cu", "Church slavic" },
            { "cv", "Chuvash" },
            { "cy", "Wesh" },
            { "da", "Dan\u1ecbsh" },
            { "de", metaValue_DE },
            { "dv", "Divehi" },
            { "dz", "D\u1ecdzng\u1ecdka" },
            { "ee", "Ewe" },
            { "el", "Giriik\u1ecb" },
            { "en", "Bekee" },
            { "eo", "Nd\u1ecb Esperant\u1ecd" },
            { "es", "Spanishi" },
            { "et", "Nd\u1ecb Est\u1ecdn\u1ecba" },
            { "eu", "Baskwe" },
            { "fa", "Peshian\u1ee5" },
            { "ff", "Fula" },
            { "fi", "F\u1ecbn\u1ecbsh" },
            { "fj", "Fijan\u1ecb" },
            { "fo", "Far\u1ecdse" },
            { "fr", "F\u1ee5rench\u1ecb" },
            { "fy", "Westan Fr\u1ecbs\u1ecban" },
            { "ga", "\u1ecar\u1ecbsh" },
            { "gd", "S\u1ee5k\u1ecdt\u1ecbs Gel\u1ecb" },
            { "gl", "Gal\u1ecbc\u1ecban" },
            { "gn", "Gwarani" },
            { "gu", "G\u1ee5arat\u1ecb" },
            { "gv", "Mans\u1ecb" },
            { "ha", "Hausa" },
            { "he", "Hebrew" },
            { "hi", "Hind\u1ecb" },
            { "hr", "K\u1ecdr\u1ecdt\u1ecban" },
            { "ht", "Ha\u1ecbt\u1ecban nd\u1ecb Cer\u1ecdle" },
            { "hu", "H\u1ee5ngarian" },
            { "hy", "Armenian\u1ecb" },
            { "hz", "Herero" },
            { "ia", "Intal\u1ecbg\u1ee5a" },
            { "id", "Indonisia" },
            { "ig", "Igbo" },
            { "ii", "S\u1ecbch\u1ee5ay\u1ecb" },
            { "io", "Ido" },
            { "is", "Ic\u1ecbland\u1ecbk" },
            { "it", "Ital\u1ecbanu" },
            { "iu", "Inuktitut\u1ecb" },
            { "ja", "Japaniisi" },
            { "jv", "Java" },
            { "ka", "Ge\u1ecdj\u1ecban" },
            { "ki", "K\u1ecbk\u1ee5y\u1ee5" },
            { "kj", "Kwanyama" },
            { "kk", "Kazak" },
            { "kl", "Kalaal\u1ecbs\u1ee5t" },
            { "km", "Keme" },
            { "kn", "Kanhada" },
            { "ko", "Kor\u1ecba" },
            { "kr", "Kanuri" },
            { "ks", "Kashm\u1ecbr\u1ecb" },
            { "ku", "Nd\u1ecb K\u1ee5rd\u1ecbsh" },
            { "kv", "Komi" },
            { "kw", "K\u1ecdn\u1ecbsh" },
            { "ky", "Kyrayz" },
            { "la", "Lat\u1ecbn" },
            { "lb", "L\u1ee5xenb\u1ecd\u1ee5g\u1ecbsh" },
            { "lg", "Ganda" },
            { "li", "Limburgish" },
            { "ln", "L\u1ecbngala" },
            { "lo", metaValue_lo },
            { "lt", "Lituanian" },
            { "lu", "L\u1ecbba-Katanga" },
            { "lv", "Latviani" },
            { "mg", "Malagas\u1ecb" },
            { "mh", "Marshalese" },
            { "mi", "Ma\u1ecdr\u1ecb" },
            { "mk", "Mased\u1ecdn\u1ecba" },
            { "ml", "Malayalam" },
            { "mn", "M\u1ecdngol\u1ecban" },
            { "mr", "Marat\u1ecb" },
            { "ms", "Maleyi" },
            { "mt", "Mat\u1ecbse" },
            { "my", "B\u1ee5rmese" },
            { "na", metaValue_NR },
            { "nb", "N\u1ecdrwey\u1ecban B\u1ecdkmal" },
            { "nd", "N\u1ecdrt\u1ee5 Ndabede" },
            { "ne", "Nepali" },
            { "ng", "Ndonga" },
            { "nl", "D\u1ecdch\u1ecb" },
            { "nn", "N\u1ecdrwey\u1ecban Nynersk" },
            { "no", "N\u1ecdrwey\u1ecban" },
            { "nr", "S\u1ecdut Ndebele" },
            { "nv", "Navajo" },
            { "ny", "Nyanja" },
            { "oc", "Os\u1ecbtan" },
            { "om", "\u1eccromo" },
            { "or", metaValue_or },
            { "os", "Osetik" },
            { "pa", "Punjabi" },
            { "pl", "Poliishi" },
            { "ps", "Pash\u1ecd" },
            { "pt", "P\u1ecdrt\u1ee5g\u1ee5ese" },
            { "qu", "Q\u1ee5ech\u1ee5a" },
            { "rm", "R\u1ecdmans\u1ecb" },
            { "rn", "R\u1ee5nd\u1ecb" },
            { "ro", metaValue_RO },
            { "ru", "R\u1ecdshian" },
            { "rw", "Kinyarwanda" },
            { "sa", "Sans\u1ecbk\u1ecbt" },
            { "sc", "Sardinian" },
            { "sd", "S\u1ecbndh" },
            { "se", "N\u1ecdrtan Sam\u1ecb" },
            { "sg", "Sang\u1ecd" },
            { "si", metaValue_si },
            { "sk", "Slova" },
            { "sl", "Slov\u1ecban" },
            { "sm", "Sam\u1ecda" },
            { "sn", "Sh\u1ecdna" },
            { "so", "Somali" },
            { "sq", "Albanian\u1ecb" },
            { "sr", "Seb\u1ecban" },
            { "ss", "Swati" },
            { "st", "S\u1ecd\u1ee5th Soto" },
            { "su", "Sudanese" },
            { "sv", "S\u1ee5widiishi" },
            { "sw", "Swahili" },
            { "ta", "Tamil" },
            { "te", metaValue_te },
            { "tg", "Taj\u1ecbk" },
            { "th", "Ta\u1ecb" },
            { "ti", "T\u1ecbgr\u1ecbnya" },
            { "tk", "Turk\u1ecbs" },
            { "tn", "Swana" },
            { "to", "T\u1ecdngan" },
            { "tr", "T\u1ecdkiishi" },
            { "ts", "Songa" },
            { "tt", "Tata" },
            { "ty", "Tahitian" },
            { "ug", "\u1ee4ygh\u1ee5r" },
            { "uk", "Ukureen\u1ecb" },
            { "ur", "Urd\u1ee5" },
            { "uz", "\u1ee4zbek" },
            { "ve", "Venda" },
            { "vi", "Vietnamisi" },
            { "vo", "Volap\u1ee5" },
            { "wa", "Walo\u1ecdn" },
            { "wo", "Wol\u1ecdf" },
            { "xh", "Xh\u1ecdsa" },
            { "yi", "Y\u1ecbd\u1ecbsh" },
            { "yo", "Yoruba" },
            { "zh", "Chainisi" },
            { "zu", "Zulu" },
            { "ace", "Achinisi" },
            { "ada", "Adangme" },
            { "ady", "Adigi" },
            { "agq", "Aghem" },
            { "ain", "Ainu" },
            { "ale", "Al\u1ee5t" },
            { "alt", "S\u1ecdutarn Altai" },
            { "ann", "Obol\u1ecd" },
            { "anp", "Angika" },
            { "arn", "Mapuche" },
            { "arp", "Arapaho" },
            { "ars", "Najdi Arabik\u1ecb" },
            { "asa", "As\u1ee5" },
            { "ast", "Asturian\u1ecb" },
            { "atj", "Atikamekwe" },
            { "awa", "Awad\u1ecb" },
            { "ban", "Balinis\u1ecb" },
            { "bas", "Basa\u00e0" },
            { "bem", "Bemb\u00e0" },
            { "bez", "Bena" },
            { "bgc", "Haryanvi" },
            { "bho", "Bojpuri" },
            { "bin", "Bini" },
            { "bla", "Siksik\u00e0" },
            { "brx", "B\u1ecdd\u1ecd" },
            { "bug", "Buginis\u1ecb" },
            { "byn", "Blin" },
            { "cay", "Cayuga" },
            { "ccp", metaValue_ccp },
            { "ceb", "Ceb\u1ee5an\u1ecd" },
            { "cgg", "Chiga" },
            { "chk", "Chukis\u1ecb" },
            { "chm", "Mari" },
            { "cho", "Choctawu" },
            { "chp", "Chipewan" },
            { "chr", "Cheroke" },
            { "chy", "Cheyene" },
            { "ckb", "Kurdish \u1ecdsote" },
            { "clc", "Chilcotin\u1ecb" },
            { "crg", "M\u1ecbchif" },
            { "crj", "S\u1ecdutarn East kree" },
            { "crk", "Plains kree" },
            { "crl", "N\u1ecdrtan East\u1ecb Kree" },
            { "crm", "Mo\u1ecdse kree" },
            { "crr", "Carolina Algon\u1ecbkwan" },
            { "csw", "Swampi kree" },
            { "dak", "Dakota" },
            { "dar", "Dagwa" },
            { "dav", "Ta\u1ecbta" },
            { "dgr", "Dogrib\u1ee5" },
            { "dje", "Zarma" },
            { "doi", "Dogri" },
            { "dsb", "Lowa Sorb\u1ecban" },
            { "dua", "D\u1ee5ala" },
            { "dyo", "J\u1ecdla-F\u1ecdny\u1ecb" },
            { "dzg", "Dazaga" },
            { "ebu", "Eb\u1ee5m" },
            { "efi", "Efik" },
            { "eka", "Ekajuk\u1ee5" },
            { "ewo", "Ew\u1ecdnd\u1ecd" },
            { "fil", "F\u1ecbl\u1ecbp\u1ecbn\u1ecd" },
            { "fon", "Fon" },
            { "frc", "Kajun Furench\u1ecb" },
            { "frr", "N\u1ecdrtan Frisian" },
            { "fur", "Fr\u1ee5l\u1ecban" },
            { "gaa", "Ga" },
            { "gez", "G\u1ecbz\u1ecb" },
            { "gil", "Gilbertis\u1ecb" },
            { "gor", "Gorontalo" },
            { "gsw", "German Swiss" },
            { "guz", "G\u1ee5sh\u1ecb" },
            { "gwi", "Gwichin" },
            { "hai", "Haida" },
            { "haw", "Hawa\u1ecbl\u1ecban" },
            { "hax", "S\u1ecdutarn Haida" },
            { "hil", "Hiligayanon" },
            { "hmn", "Hmong" },
            { "hsb", "\u1ee4pa S\u1ecdrb\u1ecba" },
            { "hup", "Hupa" },
            { "hur", "Halkomelem" },
            { "iba", "Iban\u1ecb" },
            { "ibb", "Ibibio" },
            { "ikt", "Westarn Canadian Inuktitut" },
            { "ilo", "Iloko" },
            { "inh", "Ingush" },
            { "jbo", "Lojban" },
            { "jgo", "Ng\u1ecdmba" },
            { "jmc", "Machame" },
            { "kab", "Kabyle" },
            { "kac", "Kachin" },
            { "kaj", "Ju" },
            { "kam", "Kamba" },
            { "kbd", "Kabadian" },
            { "kcg", "T\u1ecbyap" },
            { "kde", "Mak\u1ecdnde" },
            { "kea", "Kab\u1ee5verd\u1ecban\u1ee5" },
            { "kfo", "Koro" },
            { "kgp", "Kainganga" },
            { "kha", "Khasi" },
            { "khq", "K\u1ecdyra Ch\u1ecbn\u1ecb" },
            { "kkj", "Kak\u1ecd" },
            { "kln", "Kalenj\u1ecbn" },
            { "kmb", "Kimbund\u1ee5" },
            { "kok", "K\u1ecdnkan\u1ecb" },
            { "kpe", "Kpele" },
            { "krc", "Karach\u00e9-Balka" },
            { "krl", "Karelian" },
            { "kru", "Kuruk" },
            { "ksb", "Shabala" },
            { "ksf", "Baf\u1ecba" },
            { "ksh", "Cologn\u1ecban" },
            { "kum", "Kumik" },
            { "kwk", "Kwakwala" },
            { "lad", "Ladino" },
            { "lag", "Lang\u1ecb" },
            { "lez", "Lezgian" },
            { "lil", "Liloet\u1ecb" },
            { "lkt", "Lakota" },
            { "lou", "Louisiana Kreole" },
            { "loz", "Lozi" },
            { "lrc", "N\u1ecdrt\u1ee5 L\u1ee5r\u1ecb" },
            { "lsm", "Samia" },
            { "lua", "Luba-Lulua" },
            { "lun", "Lunda" },
            { "lus", "Mizo" },
            { "luy", "L\u1ee5y\u1ecba" },
            { "mad", "Madurese" },
            { "mag", "Magahi" },
            { "mai", "Ma\u1ecbt\u1ecbl\u1ecb" },
            { "mak", "Makasa" },
            { "mas", "Masa\u1ecb" },
            { "mdf", "Moksha" },
            { "men", "Mende" },
            { "mer", "Mer\u1ee5" },
            { "mfe", "M\u1ecdr\u1ecbsye" },
            { "mgh", "Mak\u1ee5wa Met\u1ecd" },
            { "mgo", "Meta" },
            { "mic", "M\u1ecbkmak" },
            { "min", "M\u1ecbnangkabau" },
            { "mni", "Man\u1ecbp\u1ee5r\u1ecb" },
            { "moe", "Inu-imun" },
            { "moh", "Moh\u1ecdk" },
            { "mos", "Mossi" },
            { "mua", "M\u1ee5dang" },
            { "mul", "\u1ecct\u1ee5t\u1ee5 as\u1ee5s\u1ee5" },
            { "mus", "Muscogee" },
            { "mwl", "M\u1ecbrandis\u1ecb" },
            { "myv", "Erzaya" },
            { "mzn", "Mazandaran\u1ecb" },
            { "nap", "N\u1ecbapolitan" },
            { "naq", "Nama" },
            { "nds", "Lowa German" },
            { "new", "N\u1ecbwari" },
            { "nia", "Nias" },
            { "niu", "Niwan" },
            { "nmg", "Kwas\u1ecb\u1ecd" },
            { "nnh", "Nglemb\u1ecdn" },
            { "nog", "Nogai" },
            { "nqo", "Nk\u1ecd" },
            { "nso", "N\u1ecdrtan Sot\u1ecd" },
            { "nus", "N\u1ee5er" },
            { "nyn", "Nyak\u1ecdle" },
            { "ojb", "N\u1ecdrtwestan Ojibwa" },
            { "ojc", "Ojibwa \u1ecdsote" },
            { "ojs", "Oji-kree" },
            { "ojw", "Westarn Ojibwa" },
            { "oka", "Okanagan" },
            { "pag", "Pangasinan" },
            { "pam", "Pampanga" },
            { "pap", "Pap\u1ecbamento" },
            { "pau", "Palawan" },
            { "pcm", "Pidg\u1ecbn" },
            { "pis", "Pij\u1ecbn" },
            { "pqm", "Maliset-Pasamakwod\u1ecb" },
            { "prg", "Pr\u1ee5ss\u1ecban" },
            { "raj", "Rajastani" },
            { "rap", "Rapunw\u1ecb" },
            { "rar", "Rarotongan\u1ecb" },
            { "rhg", "Rohinga" },
            { "rof", "R\u1ecdmb\u1ecd" },
            { "rup", "Aromanian" },
            { "rwk", "Rwa" },
            { "sad", "Sandawe" },
            { "sah", "Saka" },
            { "saq", "Samb\u1ee5r\u1ee5" },
            { "sat", "Santal\u1ecb" },
            { "sba", "Nkamb\u00e9" },
            { "sbp", "Sang\u1ee5" },
            { "scn", "Sis\u1ecblian" },
            { "sco", "Scots" },
            { "seh", "Sena" },
            { "ses", "K\u1ecdyraboro Sen\u1ecb" },
            { "shi", "Tach\u1ecbk\u1ecbt" },
            { "shn", "Shan" },
            { "slh", "S\u1ecdutarn Lusho\u1ecdtseed" },
            { "smn", "Inar\u1ecb Sam\u1ecb" },
            { "sms", "Skolt sami" },
            { "snk", "Sonink\u00e9" },
            { "srn", "Sranan Tongo" },
            { "str", "Straits Salish" },
            { "suk", "Sukuma" },
            { "swb", "Komor\u1ecban" },
            { "syr", "Sir\u1ecbak" },
            { "tce", "S\u1ecdutarn Tuchone" },
            { "tem", "Timne" },
            { "teo", "Tes\u1ecd" },
            { "tet", "Tetum" },
            { "tgx", "Tagish" },
            { "tht", "Tahitan" },
            { "tig", "T\u1ecbgre" },
            { "tlh", "Klingon" },
            { "tli", "Tl\u1ecbng\u1ecbt" },
            { "tok", "Tok\u1ecb p\u1ecdna" },
            { "tpi", "Tok pisin" },
            { "trv", "Tarok\u1ecd" },
            { "ttm", "N\u1ecdrtan Tuchone" },
            { "tum", "Tumbuka" },
            { "tvl", metaValue_TV },
            { "twq", "Tasawa" },
            { "tyv", "Tuvinian" },
            { "tzm", "Central Atlas" },
            { "udm", "Udum\u1ee5rt" },
            { "umb", "Umb\u1ee5nd\u1ee5" },
            { "und", "As\u1ee5s\u1ee5 amagh\u1ecb" },
            { "vai", "Val" },
            { "vun", "V\u1ee5nj\u1ecd" },
            { "wae", "Wasa" },
            { "wal", "Wole\u1ecbta" },
            { "war", "Wara\u1ecb" },
            { "wuu", "W\u1ee5 Chainis\u1ecb" },
            { "xal", "Kalmik" },
            { "xog", "S\u1ecdga" },
            { "yav", "Yangben" },
            { "ybb", "Yemba" },
            { "yrl", "Nheengat\u1ee5" },
            { "yue", "Kat\u1ecdn\u1ecbse" },
            { "zgh", "Standard Moroccan Tamazait" },
            { "zun", "Zuni" },
            { "zxx", "Nd\u1ecb \u1ecdz\u1ecd ab\u1ee5gh\u1ecb as\u1ee5s\u1ee5" },
            { "zza", "Zaza" },
            { "Adlm", "Adlam" },
            { "Arab", "Mkp\u1ee5r\u1ee5 Okwu Arabic" },
            { "Aran", "Nastalik" },
            { "Armn", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Armen\u1ecban" },
            { "Beng", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Bangla" },
            { "Bopo", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Bopomofo" },
            { "Brai", "Bra\u1ecblle" },
            { "Cakm", metaValue_ccp },
            { "Cans", "Unified Canadian Aboriginal Syllabics" },
            { "Cher", "Cher\u1ecdkee" },
            { "Cyrl", "Mkp\u1ee5r\u1ee5 Okwu Cyrillic" },
            { "Deva", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Devangar\u1ecb" },
            { "Ethi", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Et\u1ecdp\u1ecba" },
            { "Geor", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Ge\u1ecdj\u1ecban" },
            { "Grek", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 gr\u1ecbk" },
            { "Gujr", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 G\u1ee5jarat\u1ecb" },
            { "Guru", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 G\u1ee5rm\u1ee5k\u1ecb" },
            { "Hanb", "Han na Bopomofo" },
            { "Hang", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Hang\u1ee5l" },
            { "Hani", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Han" },
            { "Hans", "Nke d\u1ecb mfe" },
            { "Hant", "Izugbe" },
            { "Hebr", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Hebrew" },
            { "Hira", "Mkp\u1ee5r\u1ee5 okw\u1ee5 H\u1ecbragana" },
            { "Hrkt", "mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Japan\u1ecbs\u1ecb" },
            { "Jamo", "Jam\u1ecd" },
            { "Jpan", "Japanese" },
            { "Kana", "Katakana" },
            { "Khmr", "Khmer" },
            { "Knda", "Kannaada" },
            { "Kore", "Korea" },
            { "Laoo", metaValue_lo },
            { "Latn", "Latin" },
            { "Mlym", "Malayala" },
            { "Mong", "M\u1ecdng\u1ecdl\u1ecban" },
            { "Mtei", "Meitei Mayek" },
            { "Mymr", "Myanmar" },
            { "Nkoo", "Nko\u1ecd" },
            { "Olck", "Ochiki" },
            { "Orya", metaValue_or },
            { "Rohg", "Hanifi" },
            { "Sinh", metaValue_si },
            { "Sund", "Sundanis\u1ecb" },
            { "Syrc", "Syriak" },
            { "Taml", "Tam\u1ecbl" },
            { "Telu", metaValue_te },
            { "Tfng", "Tifinag" },
            { "Thaa", "Taa" },
            { "Tibt", "T\u1ecbbeta" },
            { "Vaii", "Vai" },
            { "Yiii", "Y\u1ecb" },
            { "Zmth", "Mkp\u1ee5r\u1ee5 \u1ecdkw\u1ee5 Mgbak\u1ecd" },
            { "Zsye", "Emoj\u1ecb" },
            { "Zsym", "Akara" },
            { "Zxxx", "Edegh\u1ecb ede" },
            { "Zyyy", "k\u1ecdm\u1ecdn" },
            { "Zzzz", "Mkp\u1ee5r\u1ee5 okwu amagh\u1ecb" },
            { "de_AT", "Jaman nd\u1ecb Austria" },
            { "de_CH", "Jaman Izugbe nd\u1ecb Switzerland" },
            { "en_AU", "Bekee nd\u1ecb Australia" },
            { "en_CA", "Bekee nd\u1ecb Canada" },
            { "en_GB", "Bekee nd\u1ecb United Kingdom" },
            { "en_US", "Bekee nd\u1ecb America" },
            { "es_ES", "Spanishi nd\u1ecb Europe" },
            { "es_MX", "Spanishi nd\u1ecb Mexico" },
            { "fr_CA", "F\u1ee5rench nd\u1ecb Canada" },
            { "fr_CH", "F\u1ee5rench nd\u1ecb Switzerland" },
            { "pt_BR", "P\u1ecdrt\u1ee5g\u1ee5ese nd\u1ecb Brazil" },
            { "pt_PT", "As\u1ee5s\u1ee5 Portuguese nd\u1ecb Europe" },
            { "ar_001", "\u1ee4d\u1ecb Arabiik\u1ecb nke oge a" },
            { "es_419", "Spanishi nd\u1ecb Latin America" },
            { "key.ca", "Kal\u1ecbnda" },
            { "key.cf", "\u1ee4s\u1ecdr\u1ecd eg\u1ecd" },
            { "key.co", "\u1ee4s\u1ecdr\u1ecd Nhaz\u1ecb" },
            { "key.cu", "Eg\u1ecd" },
            { "key.hc", "\u1eccge \u1ecdk\u1ecbr\u1ecbk\u1ecbr\u1ecb" },
            { "key.lb", "Akara akanka nkw\u1ee5s\u1ecb" },
            { "key.ms", "\u1ee4s\u1ecdr\u1ecd Mmesh\u1ecd" },
            { "key.nu", "N\u1ecdmba" },
            { "zh_Hans", "As\u1ee5s\u1ee5 Chinese d\u1ecb mfe" },
            { "zh_Hant", "As\u1ee5s\u1ee5 Chinese Izugbe" },
            { "type.ca.roc", "Kal\u1ecbnda rep\u1ee5blic nke China" },
            { "type.hc.h11", "\u1ee4s\u1ecdr\u1ecd \u1eccge \u1ecdk\u1ecbr\u1ecbk\u1ecbri 12" },
            { "type.hc.h12", "\u1ee4s\u1ecdr\u1ecd Oge ok\u1ecbr\u1ecbk\u1ecbri 12" },
            { "type.hc.h23", "\u1ee4s\u1ecdr\u1ecd Oge ok\u1ecbr\u1ecbk\u1ecbr\u1ecb 24" },
            { "type.hc.h24", "\u1ee4s\u1ecdr\u1ecd \u1eccge ok\u1ecbr\u1ecbk\u1ecbr\u1ecb 24" },
            { "type.nu.arab", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Arab na Ind\u1ecb" },
            { "type.nu.armn", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Armen\u1ecban" },
            { "type.nu.beng", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Bang" },
            { "type.nu.cakm", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Chakma" },
            { "type.nu.deva", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Devanagar\u1ecb" },
            { "type.nu.ethi", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Et\u1ecdp\u1ecba" },
            { "type.nu.geor", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Ge\u1ecdj\u1ecban" },
            { "type.nu.grek", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Greek" },
            { "type.nu.gujr", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 G\u1ee5jarat\u1ecb" },
            { "type.nu.guru", "On\u1ee5 \u1ecdg\u1ee5g\u1ee5 G\u1ee5m\u1ee5kh" },
            { "type.nu.hans", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 mfe Ch\u1ecbnese" },
            { "type.nu.hant", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 \u1ecddinala chinese" },
            { "type.nu.hebr", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Hebrew" },
            { "type.nu.java", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Javan\u1ecbs\u1ecb" },
            { "type.nu.jpan", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Japanese" },
            { "type.nu.khmr", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Khmer" },
            { "type.nu.knda", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Kanada" },
            { "type.nu.laoo", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 La\u1ecd" },
            { "type.nu.latn", "\u1eccn\u1ee5 \u1eccg\u1ee5g\u1ee5 Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5" },
            { "type.nu.mlym", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Malayala" },
            { "type.nu.mtei", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Meetei Mayek" },
            { "type.nu.mymr", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Myamar" },
            { "type.nu.olck", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Ochiki" },
            { "type.nu.orya", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 \u1eccd\u1ecba" },
            { "type.nu.taml", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 \u1ecdd\u1ecbnala Tam\u1ecbl" },
            { "type.nu.telu", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Tel\u1ee5g\u1ee5" },
            { "type.nu.thai", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Ta\u1ecb" },
            { "type.nu.tibt", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 T\u1ecbbeta" },
            { "type.nu.vaii", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Vai" },
            { "type.ca.dangi", "Kal\u1ecbnda Dang" },
            { "type.co.ducet", "Default Unicode \u1ee5s\u1ecdr\u1ecd nhaz\u1ecb" },
            { "type.lb.loose", "Akara akanka nkw\u1ee5s\u1ecb es\u1ecbgh\u1ecb \u1ecbke" },
            { "type.nu.roman", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Roman" },
            { "type.ca.coptic", "Kalenda Koptic" },
            { "type.ca.hebrew", "Kal\u1ecbnda Hebrew" },
            { "type.co.search", "\u1eccch\u1ee5ch\u1ee5 n\u1ecble" },
            { "type.lb.normal", "Akara akanka nkw\u1ee5s\u1ecb kwes\u1ecbr\u1ecb" },
            { "type.lb.strict", "Akara akanka nkw\u1ee5s\u1ecb s\u1ecbr\u1ecb \u1ecbke" },
            { "type.ms.metric", "\u1ee4s\u1ecdr\u1ecd Met\u1ecbr\u1ecbk" },
            { "type.ca.chinese", "Kal\u1ecbnda Chinese" },
            { "type.ca.islamic", metaValue_type_ca_islamic },
            { "type.ca.iso8601", "Kalenda ISO-8601" },
            { "type.ca.persian", "Kal\u1ecbnda Persian" },
            { "type.cf.account", "\u1ee4s\u1ecdr\u1ecd akant\u1ee5 eg\u1ecd" },
            { "type.nu.arabext", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Arab na Ind\u1ecb agbat\u1ecbr\u1ecb" },
            { "type.nu.armnlow", "\u1ecdbere \u1ecdn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Armen\u1ecban" },
            { "type.nu.greklow", "\u1eccbere \u1ecdn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Greek" },
            { "type.nu.hanidec", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 nt\u1ee5p\u1ecd Ch\u1ecbnese" },
            { "type.nu.hansfin", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 akant\u1ee5 mfe nke Chinese" },
            { "type.nu.hantfin", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 akant\u1ee5 \u1ecdd\u1ecbnala Chinese" },
            { "type.nu.jpanfin", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 akant\u1ee5 Japanese" },
            { "type.nu.tamldec", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Tam\u1ecb" },
            { "type.ca.buddhist", "Kal\u1ecbnda B\u1ee5dd\u1ecbst" },
            { "type.ca.ethiopic", "Kal\u1ecbnda Etop\u1ecba" },
            { "type.ca.japanese", "Kal\u1ecbnda Japanese" },
            { "type.cf.standard", "\u1ee4s\u1ecdr\u1ecd eg\u1ecd nz\u1ee5gbe" },
            { "type.co.standard", "Usoro Nhazi" },
            { "type.ms.uksystem", "\u1ee4s\u1ecdr\u1ecd Mmesh\u1ecd \u1ecbmper\u1ecba" },
            { "type.ms.ussystem", "\u1ee4s\u1ecdr\u1ecd Mmesh\u1ecd US" },
            { "type.nu.fullwide", "\u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 \u1ecdb\u1ecdsara" },
            { "type.nu.romanlow", "\u1eccbere \u1eccn\u1ee5 \u1ecdg\u1ee5g\u1ee5 Roman" },
            { "type.ca.gregorian", "Kalenda Gregory" },
            { "type.ca.islamic-civil", metaValue_type_ca_islamic },
            { "type.ca.islamic-umalqura", "Kalenda Hijri (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Etiopic Amete Alem Kalenda" },
        };
        return data;
    }
}
