/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_tt extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "\u0413\u0440\u0438\u043d\u0432\u0438\u0447 \u0443\u0440\u0442\u0430\u0447\u0430 \u0432\u0430\u043a\u044b\u0442\u044b",
               "GMT",
               "",
               "BST",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "",
               "",
               "",
               "",
               "\u0410\u043a\u0440 \u0432\u0430\u043a\u044b\u0442\u044b",
               "",
            };
        final String[] Anadyr = new String[] {
               "",
               "",
               "",
               "",
               "\u0410\u043d\u0430\u0434\u044b\u0440\u044c \u0432\u0430\u043a\u044b\u0442\u044b",
               "",
            };
        final String[] Samara = new String[] {
               "",
               "",
               "",
               "",
               "\u0421\u0430\u043c\u0430\u0440\u0430 \u0432\u0430\u043a\u044b\u0442\u044b",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "\u0411\u04e9\u0442\u0435\u043d\u0434\u04e9\u043d\u044c\u044f \u043a\u0438\u043b\u0435\u0448\u0442\u0435\u0440\u0435\u043b\u0433\u04d9\u043d \u0432\u0430\u043a\u044b\u0442\u044b",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Atlantic = new String[] {
               "\u0422\u04e9\u043d\u044c\u044f\u043a \u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u0433\u0430\u0434\u04d9\u0442\u0438 \u0430\u0442\u043b\u0430\u043d\u0442\u0438\u043a \u0432\u0430\u043a\u044b\u0442\u044b",
               "AST",
               "\u0422\u04e9\u043d\u044c\u044f\u043a \u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u0497\u04d9\u0439\u0433\u0435 \u0430\u0442\u043b\u0430\u043d\u0442\u0438\u043a \u0432\u0430\u043a\u044b\u0442\u044b",
               "AST",
               "\u0422\u04e9\u043d\u044c\u044f\u043a \u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u0430\u0442\u043b\u0430\u043d\u0442\u0438\u043a \u0432\u0430\u043a\u044b\u0442\u044b",
               "AST",
            };
        final String[] Kamchatka = new String[] {
               "",
               "",
               "",
               "",
               "\u041f\u0435\u0442\u0440\u043e\u043f\u0430\u0432\u043b\u043e\u0432\u0441\u043a-\u041a\u0430\u043c\u0447\u0430\u0442\u0441\u043a\u0438\u0439 \u0432\u0430\u043a\u044b\u0442\u044b",
               "",
            };
        final String[] Europe_Central = new String[] {
               "\u0433\u0430\u0434\u04d9\u0442\u0438 \u04ae\u0437\u04d9\u043a \u0415\u0432\u0440\u043e\u043f\u0430 \u0432\u0430\u043a\u044b\u0442\u044b",
               "CET",
               "\u0497\u04d9\u0439\u0433\u0435 \u04ae\u0437\u04d9\u043a \u0415\u0432\u0440\u043e\u043f\u0430 \u0432\u0430\u043a\u044b\u0442\u044b",
               "CEST",
               "\u04ae\u0437\u04d9\u043a \u0415\u0432\u0440\u043e\u043f\u0430 \u0432\u0430\u043a\u044b\u0442\u044b",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "\u0433\u0430\u0434\u04d9\u0442\u0438 \u041a\u04e9\u043d\u0447\u044b\u0433\u044b\u0448 \u0415\u0432\u0440\u043e\u043f\u0430 \u0432\u0430\u043a\u044b\u0442\u044b",
               "EET",
               "\u0497\u04d9\u0439\u0433\u0435 \u041a\u04e9\u043d\u0447\u044b\u0433\u044b\u0448 \u0415\u0432\u0440\u043e\u043f\u0430 \u0432\u0430\u043a\u044b\u0442\u044b",
               "EEST",
               "\u041a\u04e9\u043d\u0447\u044b\u0433\u044b\u0448 \u0415\u0432\u0440\u043e\u043f\u0430 \u0432\u0430\u043a\u044b\u0442\u044b",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "\u0433\u0430\u0434\u04d9\u0442\u0438 \u041a\u04e9\u043d\u0431\u0430\u0442\u044b\u0448 \u0415\u0432\u0440\u043e\u043f\u0430 \u0432\u0430\u043a\u044b\u0442\u044b",
               "WET",
               "\u0497\u04d9\u0439\u0433\u0435 \u041a\u04e9\u043d\u0431\u0430\u0442\u044b\u0448 \u0415\u0432\u0440\u043e\u043f\u0430 \u0432\u0430\u043a\u044b\u0442\u044b",
               "WEST",
               "\u041a\u04e9\u043d\u0431\u0430\u0442\u044b\u0448 \u0415\u0432\u0440\u043e\u043f\u0430 \u0432\u0430\u043a\u044b\u0442\u044b",
               "WET",
            };
        final String[] America_Central = new String[] {
               "\u0422\u04e9\u043d\u044c\u044f\u043a \u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u0433\u0430\u0434\u04d9\u0442\u0438 \u04af\u0437\u04d9\u043a \u0432\u0430\u043a\u044b\u0442\u044b",
               "CST",
               "\u0422\u04e9\u043d\u044c\u044f\u043a \u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u0497\u04d9\u0439\u0433\u0435 \u04af\u0437\u04d9\u043a \u0432\u0430\u043a\u044b\u0442\u044b",
               "CDT",
               "\u0422\u04e9\u043d\u044c\u044f\u043a \u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u04af\u0437\u04d9\u043a \u0432\u0430\u043a\u044b\u0442\u044b",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "\u0422\u04e9\u043d\u044c\u044f\u043a \u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u0433\u0430\u0434\u04d9\u0442\u0438 \u043a\u04e9\u043d\u0447\u044b\u0433\u044b\u0448 \u0432\u0430\u043a\u044b\u0442\u044b",
               "EST",
               "\u0422\u04e9\u043d\u044c\u044f\u043a \u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u0497\u04d9\u0439\u0433\u0435 \u043a\u04e9\u043d\u0447\u044b\u0433\u044b\u0448 \u0432\u0430\u043a\u044b\u0442\u044b",
               "EST",
               "\u0422\u04e9\u043d\u044c\u044f\u043a \u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u043a\u04e9\u043d\u0447\u044b\u0433\u044b\u0448 \u0432\u0430\u043a\u044b\u0442\u044b",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "\u0422\u04e9\u043d\u044c\u044f\u043a \u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u0433\u0430\u0434\u04d9\u0442\u0438 \u0422\u044b\u043d \u043e\u043a\u0435\u0430\u043d \u0432\u0430\u043a\u044b\u0442\u044b",
               "PST",
               "\u0422\u04e9\u043d\u044c\u044f\u043a \u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u0497\u04d9\u0439\u0433\u0435 \u0422\u044b\u043d \u043e\u043a\u0435\u0430\u043d \u0432\u0430\u043a\u044b\u0442\u044b",
               "PDT",
               "\u0422\u04e9\u043d\u044c\u044f\u043a \u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u0422\u044b\u043d \u043e\u043a\u0435\u0430\u043d \u0432\u0430\u043a\u044b\u0442\u044b",
               "PT",
            };
        final String[] America_Mountain = new String[] {
               "\u0422\u04e9\u043d\u044c\u044f\u043a \u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u0433\u0430\u0434\u04d9\u0442\u0438 \u0442\u0430\u0443 \u0432\u0430\u043a\u044b\u0442\u044b",
               "MST",
               "\u0422\u04e9\u043d\u044c\u044f\u043a \u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u0497\u04d9\u0439\u0433\u0435 \u0442\u0430\u0443 \u0432\u0430\u043a\u044b\u0442\u044b",
               "MST",
               "\u0422\u04e9\u043d\u044c\u044f\u043a \u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u0442\u0430\u0443 \u0432\u0430\u043a\u044b\u0442\u044b",
               "MST",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "America/Halifax", Atlantic },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Europe/Bucharest", Europe_Eastern },
            { "UTC", ETC_UTC },
            { "GB", GMT },
            { "ART", Europe_Eastern },
            { "CST", America_Central },
            { "ECT", Europe_Central },
            { "IET", America_Eastern },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "UCT",
                new String[] {
                    "\u0411\u04e9\u0442\u0435\u043d\u0434\u04e9\u043d\u044c\u044f \u043a\u0438\u043b\u0435\u0448\u0442\u0435\u0440\u0435\u043b\u0433\u04d9\u043d \u0432\u0430\u043a\u044b\u0442\u044b",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Eire", GMT },
            { "GMT0", GMT },
            { "Zulu",
                new String[] {
                    "\u0411\u04e9\u0442\u0435\u043d\u0434\u04e9\u043d\u044c\u044f \u043a\u0438\u043b\u0435\u0448\u0442\u0435\u0440\u0435\u043b\u0433\u04d9\u043d \u0432\u0430\u043a\u044b\u0442\u044b",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Libya", Europe_Eastern },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "\u0411\u04e9\u0442\u0435\u043d\u0434\u04e9\u043d\u044c\u044f \u043a\u0438\u043b\u0435\u0448\u0442\u0435\u0440\u0435\u043b\u0433\u04d9\u043d \u0432\u0430\u043a\u044b\u0442\u044b",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire", GMT },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "\u0411\u04e9\u0442\u0435\u043d\u0434\u04e9\u043d\u044c\u044f \u043a\u0438\u043b\u0435\u0448\u0442\u0435\u0440\u0435\u043b\u0433\u04d9\u043d \u0432\u0430\u043a\u044b\u0442\u044b",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Portugal", Europe_Western },
            { "Asia/Gaza", Europe_Eastern },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Universal",
                new String[] {
                    "\u0411\u04e9\u0442\u0435\u043d\u0434\u04e9\u043d\u044c\u044f \u043a\u0438\u043b\u0435\u0448\u0442\u0435\u0440\u0435\u043b\u0433\u04d9\u043d \u0432\u0430\u043a\u044b\u0442\u044b",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Lome", GMT },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Hebron", Europe_Eastern },
            { "Brazil/Acre", Acre },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Tunis", Europe_Central },
            { "Asia/Nicosia", Europe_Eastern },
            { "Europe/Malta", Europe_Central },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "Africa/Bamako", GMT },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "America/Aruba", Atlantic },
            { "America/Boise", America_Mountain },
            { "America/Thule", Atlantic },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "\u0411\u04e9\u0442\u0435\u043d\u0434\u04e9\u043d\u044c\u044f \u043a\u0438\u043b\u0435\u0448\u0442\u0435\u0440\u0435\u043b\u0433\u04d9\u043d \u0432\u0430\u043a\u044b\u0442\u044b",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin", GMT },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London", GMT },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Inuvik", America_Mountain },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Kamchatka", Kamchatka },
            { "Atlantic/Faroe", Europe_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast", GMT },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Mexico/General", America_Central },
            { "Africa/Freetown", GMT },
            { "Africa/Monrovia", GMT },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "America/Antigua", Atlantic },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "America/Anguilla", Atlantic },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Troll", GMT },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Mexico/BajaNorte", America_Pacific },
            { "Africa/Nouakchott", GMT },
            { "America/Chihuahua", America_Central },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Montserrat", Atlantic },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Canada/Saskatchewan", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Etc/Unknown", "\u0431\u0438\u043b\u0433\u0435\u0441\u0435\u0437 \u0448\u04d9\u04bb\u04d9\u0440" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "America/North_Dakota/New_Salem", America_Central },
        };
        return data;
    }
}
